import get from 'lodash/get';
import { baseCallApi } from 'api/common';
import * as t from './actionTypes.js';

const { DELEGATIONS_RESET } = t;
export const resetData = () => ({
  type: DELEGATIONS_RESET,
});

const DELEGATIONS_REQUEST = `${t.DELEGATIONS_LOAD}_REQUEST`;
const DELEGATIONS_RECIEVE = `${t.DELEGATIONS_LOAD}_RECIEVE`;
const DELEGATIONS_FAIL = `${t.DELEGATIONS_LOAD}_FAIL`;
export const loadData = () => ({
  type: 'PROMISE',
  actions: [DELEGATIONS_REQUEST, DELEGATIONS_RECIEVE, DELEGATIONS_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/delegation/list',
  }).then(data => {
    if (Array.isArray(data)) {
      return data.map(item => {
        if (item && item.executorId && item.executorName) {
          return {
            ...item,
            // для нормальной иницализации компонента выбора, странный тут формат данных
            executor: {
              id: item.executorId,
              name: item.executorName,
              type: 1, // для листа бек type === 1 отдает тут, нужно чтобы выделить элемент в дереве
            },
            user: {
              id: item.userId,
              name: item.userName,
              type: 1, // для листа бек type === 1 отдает тут, нужно чтобы выделить элемент в дереве
            },
          };
        }

        return item;
      });
    }

    return data;
  }),
});

const HISTORY_REQUEST = `${t.HISTORY_LOAD}_REQUEST`;
const HISTORY_RECIEVE = `${t.HISTORY_LOAD}_RECIEVE`;
const HISTORY_FAIL = `${t.HISTORY_LOAD}_FAIL`;
export const loadHistory = () => ({
  type: 'PROMISE',
  actions: [HISTORY_REQUEST, HISTORY_RECIEVE, HISTORY_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/delegation/activity/list',
  }),
});

const { HISTORY_RESET } = t;
export const resetHistory = () => ({
  type: HISTORY_RESET,
});

const { DELEGATION_RESET } = t;
export const resetDelegation = () => ({
  type: DELEGATION_RESET,
});

const { DELEGATION_ADD } = t;
export const addDelegation = () => (dispatch, getState) => {
  const user = get(getState(), 'root.info.user');

  dispatch({
    type: DELEGATION_ADD,
    formValues: {
      user: {
        id: user.id,
        name: user.name,
        type: 1,
      },
    },
  });
};

const { DELEGATION_EDIT } = t;
export const editDelegation = (id, data) => ({
  type: DELEGATION_EDIT,
  data,
  id,
});

const DELEGATION_POST_REQUEST = `${t.DELEGATION_SAVE}_REQUEST`;
const DELEGATION_POST_RECIEVE = `${t.DELEGATION_SAVE}_RECIEVE`;
const DELEGATION_POST_FAIL = `${t.DELEGATION_SAVE}_FAIL`;
export const saveDelegation = data => ({
  type: 'PROMISE',
  actions: [DELEGATION_POST_REQUEST, DELEGATION_POST_RECIEVE, DELEGATION_POST_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/delegation/save',
    type: 'post',
    data,
  }),
  args: data,
});

const DELEGATION_DELETE_REQUEST = `${t.DELEGATION_DELETE}_REQUEST`;
const DELEGATION_DELETE_RECIEVE = `${t.DELEGATION_DELETE}_RECIEVE`;
const DELEGATION_DELETE_FAIL = `${t.DELEGATION_DELETE}_FAIL`;
export const deleteDelegation = delegationId => ({
  type: 'PROMISE',
  actions: [DELEGATION_DELETE_REQUEST, DELEGATION_DELETE_RECIEVE, DELEGATION_DELETE_FAIL],
  promise: baseCallApi({
    url: '/actions/usersettings/delegation/delete',
    type: 'post',
    data: { delegationId },
  }),
});
