import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import RenderDatePicker from 'requestForms/components/RenderDatePicker';
import DatePicker from 'requestForms/components/FieldDatePicker';
import Button from '@crm/components/dist/lego2/Button';
import Suggest from 'lego/redux-form/SuggestStaffInline2';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import css from './styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18nFromWhom = commonI18n('fromWhom');
const i18nToWhom = commonI18n('toWhom');
const i18nFrom = commonI18n('from');
const i18nTo = commonI18n('to');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nAbort = commonI18n('abort');
const i18nRemove = commonI18n('remove');

const SettingsDelegationForm = (props) => {
  const {
    handleSubmit,
    submitting,
    invalid,
    touch,
    change,
    to,
    canEditStartDate,
    canEditEndDate,
    onDelete,
    onReset,
  } = props;
  const { delegationId } = props.initialValues;

  return (
    <form className={css.root} onSubmit={handleSubmit}>
      <div className={css.row}>
        <div className={cx(css.label)}>
          <span>{i18nFromWhom}</span>
        </div>
        <div className={css.field} style={{ position: 'relative' }}>
          <Field
            className={css.userName}
            name="user"
            component={Suggest}
            variant={Suggest.StaffSuggestVariant.UsersInGroupOnly}
            onlyUserActive
            isSingleValue
            onChange={(event, value) => {
              if (value && value.id) {
                change('userId', value.id);
                change('userName', value.name);
              } else {
                change('userId', '');
                change('userName', '');
              }
            }}
          />
        </div>
      </div>

      <div className={css.row}>
        <div className={cx(css.label, css.requiredStar)}>
          <span>{i18nToWhom}</span>
        </div>
        <div className={css.field} style={{ position: 'relative' }}>
          <Field
            className={css.userName}
            name="executor"
            component={Suggest}
            variant={Suggest.StaffSuggestVariant.UsersOnly}
            onlyUserActive
            isSingleValue
            onChange={(event, value) => {
              if (value && value.id) {
                change('executorId', value.id);
                change('executorName', value.name);
              } else {
                change('executorId', '');
                change('executorName', '');
              }
            }}
          />
        </div>
      </div>

      <div className={css.rows}>
        <div className={cx(css.row, css.date)}>
          <label htmlFor="from" className={cx(css.label, css.requiredStar)}>
            <span>{i18nFrom}</span>
          </label>
          <div className={css.field}>
            <DatePicker
              name="from"
              id="from"
              className={css.formField}
              component={RenderDatePicker}
              props={{
                hasClear: false,
                disabled: canEditStartDate === false,
                size: 's',
              }}
              pickerProps={{
                minDate: new Date(),
              }}
              onChange={() => {
                touch('from');

                if (to) {
                  touch('to');
                }
              }}
            />
          </div>
        </div>
        <div className={cx(css.row, css.date)}>
          <label htmlFor="to" className={cx(css.label, css.requiredStar)}>
            <span>{i18nTo}</span>
          </label>
          <div className={css.field}>
            <DatePicker
              name="to"
              id="to"
              className={css.formField}
              component={RenderDatePicker}
              props={{
                hasClear: false,
                disabled: canEditEndDate === false,
                size: 's',
              }}
              pickerProps={{
                minDate: new Date(),
              }}
              onChange={() => {
                touch('to'); // Нужно сразу ибо "by default touched will be set when the field is blurred."
              }}
            />
          </div>
        </div>
      </div>
      <div className={css.actions}>
        <span>
          <Button
            type="submit"
            size="m"
            className={css.actionsButton}
            view="action"
            disabled={submitting || invalid}
          >
            {i18nSave}
          </Button>
          <Button
            size="m"
            view="pseudo"
            className={css.actionsButton}
            disabled={submitting}
            onClick={onReset}
          >
            {i18nCancel}
          </Button>
        </span>
        {delegationId ? (
          <Button
            view="pseudo"
            size="m"
            className={css.actionsButton}
            disabled={submitting}
            onClick={onDelete}
          >
            {!canEditStartDate ? i18nAbort : i18nRemove}
          </Button>
        ) : null}
      </div>
    </form>
  );
};

SettingsDelegationForm.propTypes = {
  to: PropTypes.string,
  canEditEndDate: PropTypes.bool,
  canEditStartDate: PropTypes.bool,
  onSubmit: PropTypes.func.isRequired,
  onDelete: PropTypes.func,
  onReset: PropTypes.func,
};

SettingsDelegationForm.defaultProps = {
  to: undefined,
  canEditEndDate: undefined,
  canEditStartDate: undefined,
  onDelete: () => {},
  onReset: () => {},
};

export default SettingsDelegationForm;
