import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import css from './styles.modules.scss';
import * as keyset from './DelegationsList.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nWho = commonI18n('who');
const i18nALogIn = commonI18n('aLogIn');
const i18nALogOut = commonI18n('aLogOut');
const i18nNoActivity = i18n('noActivity');

const RenderItem = ({ item, formatDate }) => (
  <div className={cx(css.listItem, css.listItemBlock)}>
    <span className={cx(css.col, css.name)}>
      <span className={css.userName} title={item.executorName}>
        {item.executorName}
      </span>
    </span>
    <span className={cx(css.col, css.date, css.dateLong)}>{formatDate(item.startDate)}</span>
    <span className={cx(css.col, css.date, css.dateLong)}>{formatDate(item.endDate)}</span>
  </div>
);

const SettingsDelegaitionsListHistory = props => {
  const { items: delegations, formatDate } = props;

  return delegations.length ? (
    <div className={css.data}>
      <div className={css.header}>
        <div className={css.content}>
          <div className={cx(css.col, css.name)}>{i18nWho}</div>
          <div className={cx(css.col, css.date, css.dateLong)}>{i18nALogIn}</div>
          <div className={cx(css.col, css.date, css.dateLong)}>{i18nALogOut}</div>
        </div>
      </div>
      <div className={css.list}>
        {delegations.map((item, index) => (
          <RenderItem key={index} item={item} formatDate={formatDate} />
        ))}
      </div>
    </div>
  ) : (
    <p className={cx(css.empty, css.empty_history)}>{i18nNoActivity}</p>
  );
};

SettingsDelegaitionsListHistory.propTypes = {
  items: PropTypes.arrayOf(PropTypes.object),
  formatDate: PropTypes.func,
};

SettingsDelegaitionsListHistory.defaultProps = {
  items: [],
  formatDate: () => {},
};

export default SettingsDelegaitionsListHistory;
