import React from 'react';
import { FormattedDate } from 'react-intl';
import ListView from './listView';
import HistoryView from './historyView';

const DelegationsList = (args) => {
  const { view, ...passThroughProps } = args;

  switch(view) {
    case 'list':
      return (
        <ListView
          formatDate={date => (
            <FormattedDate
              value={date}
              year="numeric"
              month="short"
              day="numeric"
            />
          )}
          {...passThroughProps}
        />
      );
      break;
    case 'history':
      return (
        <HistoryView
          formatDate={date => (
            <FormattedDate
              value={date}
              year="numeric"
              month="short"
              day="numeric"
              hour="numeric"
              minute="numeric"
            />
          )}
          {...passThroughProps}
        />
      );
      break;
    default:
      return null;
  }
}

export default DelegationsList;
