import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { ROUTE } from '../../constants';
import Delegations from '../DelegationsList';
import css from './styles.modules.scss';
import * as keyset from './History.i18n';

const i18nWorkHistory = createI18N(keyset)('workHistory');
const i18nClose = createI18N(commonKeyset)('close');

const SettingsDelegaitionsList = props => {
  if (!props.history.isLoad) return null;

  const delegations = props.history.data;

  return (
    <div className={css.root}>
      <div className={css.title}>
        {i18nWorkHistory}
        <RouterLink className={css.close} to={ROUTE}>
          {i18nClose}
        </RouterLink>
      </div>
      <Delegations view="history" items={delegations} />
    </div>
  );
};

SettingsDelegaitionsList.propTypes = {
  history: PropTypes.shape({
    data: PropTypes.arrayOf(PropTypes.object),
  }),
};

SettingsDelegaitionsList.defaultProps = {
  history: {},
};

export default SettingsDelegaitionsList;
