import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import { Route } from 'react-router-dom';
import createI18N from '@yandex-int/i18n';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import * as commonKeyset from 'common.i18n';
import { ROUTE } from '../../constants';
import Delegations from '../DelegationsList';
import Tip from '../Tip';
import css from './styles.modules.scss';
import * as keyset from './Layout.i18n';

const i18n = createI18N(keyset);
const commonI18n = createI18N(commonKeyset);
const i18nDelegationTitle = i18n('delegationTitle');
const i18nWorkHistory = i18n('workHistory');
const i18nAddNew = commonI18n('addNew');
const i18nDelegationBreadscrumb = i18n('delegationBreadscrumb');
const i18nNewDelegation = i18n('newDelegation');
const i18nEditDelegation = i18n('editDelegation');
const i18nActivityHistory = i18n('activityHistory');

const SettingsDelegationsLayout = props => {
  const { delegations, delegation, history, children } = props;
  const { isNew } = delegation;
  const { isEdit } = delegation;

  return (
    <div className={css.root}>
      <div className={css.aside}>
        <div className={css.header}>
          <div className={css.title}>
            {i18nDelegationTitle}
            <RouterLink
              className={css.history}
              activeClassName={css.historyActive}
              to={`${ROUTE}/history`}
              title={i18nWorkHistory}
            >
              <i className="material-icons">history</i>
            </RouterLink>
          </div>
          <RouterLink className={css.add} activeClassName={css.addActive} to={`${ROUTE}/new`}>
            <i className="material-icons">add_box</i>
            {i18nAddNew}
          </RouterLink>
        </div>
        {delegations.isLoad ? (
          <Delegations className={css.list} view="list" items={delegations.data} />
        ) : null}
      </div>
      <div className={css.main}>
        <div className={css.path}>
          {SettingsModule} → {i18nDelegationBreadscrumb}
          {isNew && (
            <span>
              {' '}
              → <span className={css.isNew}>{i18nNewDelegation}</span>
            </span>
          )}
          {isEdit && <span> → {i18nEditDelegation}</span>}
          <Route path={`${ROUTE}/history`} render={() => <span> → {i18nActivityHistory}</span>} />
        </div>
        {children}
        <Tip delegations={delegations} delegation={delegation} history={history} />
      </div>
    </div>
  );
};

SettingsDelegationsLayout.propTypes = {
  delegations: PropTypes.shape({
    data: PropTypes.arrayOf(PropTypes.object),
  }),
  delegation: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
};

SettingsDelegationsLayout.defaultProps = {
  delegations: {
    data: [],
  },
  delegation: {},
};

export default SettingsDelegationsLayout;
