import React from 'react';
import PropTypes from 'prop-types';
import RouterLink from 'components/RouterLink';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { ROUTE } from '../../constants';
import css from '../Layout/styles.modules.scss';
import * as keyset from './Tip.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nAddNew = commonI18n('addNew');
const i18nSomethingGoesWrong = commonI18n('somethingGoesWrong');
const i18nNoDelegations = i18nRaw('noDelegations', {
  optionalAction: <RouterLink to={{ pathname: `${ROUTE}/new` }}>{i18nAddNew}</RouterLink>,
});
const i18nChooseDelegation = i18nRaw('chooseDelegation', {
  optionalAction: <RouterLink to={{ pathname: `${ROUTE}/new` }}>{i18nAddNew}</RouterLink>,
});

const SettingsDelegationsTip = props => {
  const { delegations, delegation, history } = props;
  const delegationsItems = delegations.data || [];

  if (!delegations.isLoad) return null;
  else if (
    !delegation.isNew &&
    !delegation.isEdit &&
    !history.isLoad &&
    (delegation.isError || delegations.isError)
  ) {
    return <div className={css.tip}>{i18nSomethingGoesWrong}</div>;
  } else if (
    !delegationsItems.length &&
    !delegation.isEdit &&
    !delegation.isNew &&
    !history.isLoad
  ) {
    return (
      <div className={css.tip}>{i18nNoDelegations}</div>
    );
  } else if (delegation.isSave && !delegation.data.delegationId) {
    return (
      <div className={css.tip}>{i18n('delegationCreated', { colleague: delegation.data.executorName })}</div>
    );
  } else if (delegation.isSave) {
    return (
      <div className={css.tip}>{i18n('delegationSaved', { colleague: delegation.data.executorName })}</div>
    );
  } else if (delegation.isDelete) {
    return (
      <div className={css.tip}>{i18n('delegationRemoved', { colleague: delegation.data.executorName })}</div>
    );
  } else if (
    (!delegation.isEdit && !delegation.isNew && !history.isLoad) ||
    (delegation.isEdit && !delegation.data.canEditEndDate && !delegation.data.canEditStartDate)
  ) {
    return (
      <div className={css.tip}>{i18nChooseDelegation}</div>
    );
  }
  return null;
};

SettingsDelegationsTip.propTypes = {
  delegation: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  delegations: PropTypes.shape({
    data: PropTypes.arrayOf(PropTypes.object),
  }),
};

SettingsDelegationsTip.defaultProps = {
  delegation: {},
  delegations: {
    data: [],
  },
};

export default SettingsDelegationsTip;
