import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import get from 'lodash/get';
import routeController from 'modules/settings/utils/routeController';
import { NAME, ROUTE } from '../constants';
import * as actions from '../actions';
import DelegationForm from './DelegationForm';

const mapState = state => ({
  delegations: get(state, `${NAME}.delegations`),
  delegation: get(state, `${NAME}.delegation`),
});

const mapDispatch = dispatch => ({
  addDelegation: () => dispatch(actions.addDelegation()),
  editDelegation: (id, data) => dispatch(actions.editDelegation(id, data)),
  resetDelegation: () => dispatch(actions.resetDelegation()),
});

class SettingsDelegation extends Component {
  constructor(props) {
    super(props);

    this.routeController = routeController({
      add: props.addDelegation,
      edit: id => {
        this.edit(id);
      },
      reset: () => {
        const { resetDelegation, router } = props;

        resetDelegation();
        router.push(ROUTE);
      },
    });
  }

  componentDidMount() {
    const { id } = this.props.routeParams;

    this.routeController({
      isNew: id === 'new',
      id,
    });
  }

  componentWillReceiveProps(newProps) {
    if (newProps.routeParams.id !== this.props.routeParams.id) {
      const { id } = newProps.routeParams;

      this.routeController({
        isNew: id === 'new',
        id,
      });
    }
  }

  componentDidUpdate(prevProps) {
    const { props } = this;

    if (!prevProps.delegations.isLoad && props.delegations.isLoad) {
      this.routeController({
        id: props.routeParams.id,
      });
    }
  }

  componentWillUnmount() {
    this.props.resetDelegation();
  }

  edit = id => {
    const { props } = this;

    if (props.delegations.isLoad) {
      props.editDelegation(id, get(props, 'delegations.data'));
    }
  };

  render() {
    const { delegation, router } = this.props;

    if (
      (!delegation.isNew && !delegation.isEdit) ||
      (delegation.isEdit && !delegation.data.canEditEndDate && !delegation.data.canEditStartDate)
    ) {
      return null;
    }

    const formName = `SettingsDelegation${(delegation.data && delegation.data.delegationId) ||
      'New'}`;

    return (
      <DelegationForm
        key={formName}
        form={formName}
        initialValues={delegation.data}
        router={router}
      />
    );
  }
}

SettingsDelegation.propTypes = {
  route: PropTypes.instanceOf(Object).isRequired,
  routeParams: PropTypes.instanceOf(Object).isRequired,
};

export default connect(mapState, mapDispatch)(SettingsDelegation);
