import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import History from '../components/History';

const mapState = state => ({
  history: get(state, `${NAME}.history`),
});

const mapDispatch = dispatch => ({
  loadHistory: () => dispatch(actions.loadHistory()),
  resetHistory: () => dispatch(actions.resetHistory()),
});

class SettingsDelegationsHistory extends Component {
  componentWillMount() {
    this.props.loadHistory();
  }

  componentWillUnmount() {
    this.props.resetHistory();
  }

  render() {
    const { history } = this.props;

    if (!history.isLoad) {
      return null;
    }

    return <History {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(SettingsDelegationsHistory);
