import React, { Component } from 'react';
import ModalField from 'uiLib/ModalField';
import Popup from '@crm/components/dist/lego2/Popup';
import Tree, { getSlugId } from './container';
import treeNodeTheme from './styles.modules.scss';

export default class User extends Component {
  static defaultProps = {
    part: 'all',
  };

  constructor(props) {
    super(props);

    this.state = {
      show: false,
    };

    this.treeField = React.createRef();
  }

  setUser = (id, item) => {
    if (item.type !== 1) return;

    const {
      input: { value, onChange },
    } = this.props;

    if (value && getSlugId(value) === id) {
      onChange({});
    } else {
      onChange({ id: item.id, name: item.name, type: item.type });
      this.hidePopup();
    }
  };

  togglePopup = () => {
    this.setState({ show: !this.state.show });
  };

  hidePopup = () => {
    this.setState({ show: false });
  };

  render() {
    const {
      className,
      input: { value },
      part,
    } = this.props;
    const tree = (
      <Tree
        treeNodeTheme={treeNodeTheme}
        onClick={this.setUser}
        selected={getSlugId(value)}
        endpoint={`/view/staff/user/tree?part=${part}`}
        destroyOnUnmount
      />
    );

    return (
      <span className={className}>
        <ModalField onClick={this.togglePopup} fieldRef={this.treeField}>
          {value && value.name}
        </ModalField>
        <Popup
          visible={this.state.show}
          onOutsideClick={this.hidePopup}
          directions="bottom"
          target="anchor"
          anchor={this.treeField}
          padding="xs"
          zIndex={100}
        >
          {tree}
        </Popup>
      </span>
    );
  }
}
