import { combineReducers } from 'redux';
import * as t from './actionTypes';

const delegations = (state = {}, action) => {
  switch (action.type) {
    case t.DELEGATIONS_RESET:
      return {};

    case `${t.DELEGATIONS_LOAD}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.DELEGATIONS_LOAD}_RECIEVE`:
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    case `${t.DELEGATIONS_LOAD}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    default:
      return state;
  }
};

const history = (state = {}, action) => {
  switch (action.type) {
    case t.HISTORY_RESET:
      return {};

    case `${t.HISTORY_LOAD}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.HISTORY_LOAD}_RECIEVE`:
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    case `${t.HISTORY_LOAD}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };

    default:
      return state;
  }
};

const delegation = (state = {}, action) => {
  switch (action.type) {
    case t.DELEGATION_RESET:
      return {};

    case t.DELEGATION_ADD:
      return {
        ...state,
        data: action.formValues,
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isHistory: false,
        isReset: false,
      };

    case t.DELEGATION_EDIT: {
      const result = {
        ...state,
        isNew: false,
        isSave: false,
        isDelete: false,
        isHistory: false,
        isReset: false,
      };
      let delegation;

      action.data.some(item => {
        const result = item.delegationId === action.id;

        if (result) {
          delegation = item;
        }

        return result;
      });

      if (delegation) {
        result.data = delegation;
        result.isEdit = true;
        result.isError = false;
      } else {
        result.isEdit = false;
        result.isError = true;
      }

      return result;
    }

    case `${t.DELEGATION_SAVE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.DELEGATION_SAVE}_RECIEVE`:
      return {
        ...state,
        data: action.args,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isHistory: false,
        isReset: false,
        isError: false,
      };
    case `${t.DELEGATION_SAVE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };

    case `${t.DELEGATION_DELETE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.DELEGATION_DELETE}_RECIEVE`:
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isHistory: false,
        isReset: false,
        isError: false,
      };
    case `${t.DELEGATION_DELETE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };

    default:
      return state;
  }
};

export default combineReducers({ delegations, history, delegation });
