import React from 'react';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import createI18N from '@yandex-int/i18n';
import { Switch, Route } from 'react-router-dom';
import * as keyset from './delegation.i18n';
import Layout from './containers/Layout';
import History from './containers/History';
import Delegation from './containers/Delegation';

const i18nTitle = createI18N(keyset)('title');

const Auth = moduleAuthorization('settingsAccess.delegations')(Layout);

const DelegationAdapter = ({ match, history }) => (
  <Delegation params={match.params} routeParams={match.params} router={history} />
);

const DelegationRouter = ({ match }) => (
  <Auth>
    <TitleChain>{i18nTitle}</TitleChain>
    <Switch>
      <Route path={`${match.url}/history`} component={History} />
      <Route path={`${match.url}/:id`} component={DelegationAdapter} />
    </Switch>
  </Auth>
);

export default DelegationRouter;
