import { baseCallApi, get } from 'api/common';
import * as t from './actionTypes.js';

export const resetData = () => ({
  type: t.FOLDERS_TAGS_RESET,
});

const FOLDERS_TAGS_REQUEST = `${t.FOLDERS_TAGS_LOAD}_REQUEST`;
const FOLDERS_TAGS_RECIEVE = `${t.FOLDERS_TAGS_LOAD}_RECIEVE`;
const FOLDERS_TAGS_FAIL = `${t.FOLDERS_TAGS_LOAD}_FAIL`;
export const loadData = () => ({
  type: 'PROMISE',
  actions: [FOLDERS_TAGS_REQUEST, FOLDERS_TAGS_RECIEVE, FOLDERS_TAGS_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/foldertag/list',
  }),
});

export const getUserTags = type => ({
  type: 'PROMISE',
  actions: [FOLDERS_TAGS_REQUEST, FOLDERS_TAGS_RECIEVE, FOLDERS_TAGS_FAIL],
  promise: get({
    url: '/view/usertags',
    data: {
      type,
    },
  }).then(data => ({ tags: data })),
});

export const loadByType = type => (type ? getUserTags(type) : loadData());

export const resetFolder = () => ({
  type: t.FOLDER_RESET,
});

export const addFolder = () => ({
  type: t.FOLDER_ADD,
});

export const editFolder = data => ({
  type: t.FOLDER_EDIT,
  data,
});

const FOLDER_POST_REQUEST = `${t.FOLDER_SAVE}_REQUEST`;
const FOLDER_POST_RECIEVE = `${t.FOLDER_SAVE}_RECIEVE`;
const FOLDER_POST_FAIL = `${t.FOLDER_SAVE}_FAIL`;
export const saveFolder = data => dispatch => {
  const promise = dispatch({
    // {folderId,name,parentId}
    type: 'PROMISE',
    actions: [FOLDER_POST_REQUEST, FOLDER_POST_RECIEVE, FOLDER_POST_FAIL],
    promise: baseCallApi({
      url: '/view/usersettings/mailfolders/save',
      type: 'post',
      data,
    }),
    args: data,
  });

  promise.then(() => {
    dispatch(loadData());
  });

  return promise;
};

const FOLDER_DELETE_REQUEST = `${t.FOLDER_DELETE}_REQUEST`;
const FOLDER_DELETE_RECIEVE = `${t.FOLDER_DELETE}_RECIEVE`;
const FOLDER_DELETE_FAIL = `${t.FOLDER_DELETE}_FAIL`;
export const deleteFolder = folderId => dispatch => {
  const promise = dispatch({
    type: 'PROMISE',
    actions: [FOLDER_DELETE_REQUEST, FOLDER_DELETE_RECIEVE, FOLDER_DELETE_FAIL],
    promise: baseCallApi({
      url: '/view/usersettings/mailfolders/detele',
      type: 'post',
      data: { folderId },
    }),
  });

  promise.then(() => {
    dispatch(loadData());
  });

  return promise;
};

export const resetTag = () => ({
  type: t.TAG_RESET,
});

export const addTag = () => ({
  type: t.TAG_ADD,
});

export const editTag = data => dispatch =>
  get({
    url: '/view/tag',
    data: { tagId: data.id },
  }).then(responseData =>
    dispatch({
      type: t.TAG_EDIT,
      data: responseData,
    }),
  );

export const saveTag = data => ({
  type: t.TAG_SAVE,
  data,
});

export const deleteTag = data => ({
  type: t.TAG_DELETE,
  data,
});
