import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as keyset from './FoldersLayout.i18n';
import FolderForm from '../../containers/FolderForm';
import FoldersList from '../FoldersList';
import Tip from '../Tips/Folders';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nTitle = i18n('title');
const i18nNewFolder = i18n('newFolder');

const SettingsFoldersLayout = props => {
  const { items, folder, defaultFolderId, tree, addFolder, editFolder } = props;
  const showFolderForm = folder.isNew || folder.isEdit;
  const formName = `SettingsFolder${(folder.data && folder.data.id) || 'New'}`;

  return (
    <div className={css.root}>
      <div className={css.title}>
        {i18nTitle}
        <a
          className={cx(css.add, folder.isNew ? css.addActive : null)}
          tabIndex="0"
          onClick={addFolder}
        >
          <i className="material-icons">add_box</i>
          {i18nNewFolder}
        </a>
      </div>
      <div className={css.content}>
        <div className={css.folders}>
          <FoldersList
            items={items}
            folder={folder}
            tree={Object.assign({}, tree)}
            editFolder={editFolder}
          />
        </div>
        <div className={css.folder}>
          <Tip folders={items} folder={folder} addFolder={addFolder} />
          {showFolderForm && (
            <FolderForm
              key={formName}
              form={formName}
              initialValues={{
                ...folder.data,
                parentId: (folder.data && folder.data.parentId) || defaultFolderId,
              }}
              defaultFolderId={defaultFolderId}
              tree={Object.assign({}, tree)}
            />
          )}
        </div>
      </div>
    </div>
  );
};

SettingsFoldersLayout.propTypes = {
  folder: PropTypes.instanceOf(Object),
  defaultFolderId: PropTypes.number,
  items: PropTypes.arrayOf(PropTypes.object),
  tree: PropTypes.instanceOf(Object),
  addFolder: PropTypes.func,
  editFolder: PropTypes.func,
};

SettingsFoldersLayout.defaultProps = {
  folder: {},
  defaultFolderId: undefined,
  items: [],
  tree: {},
  addFolder: () => {},
  editFolder: () => {},
};

export default SettingsFoldersLayout;
