import React from 'react';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as keyset from './FoldersList.i18n';
import cssTree from './foldersTheme.modules.scss';

const i18n = createI18N(keyset);

const FolderNode = props => {
  const {
    name,
    code,
    counter: { total },
  } = props;

  return (
    <div className={cx(cssTree.node, code ? cssTree.disabled : null)}>
      <span className={cssTree.name}>{name}</span>
      {total != null && (
        <span className={cssTree.count} title={i18n('count', { total })}>
          {total}
        </span>
      )}
    </div>
  );
};

export default FolderNode;
