import React from 'react';
import PropTypes from 'prop-types';
import Folders from 'modules/settings/components/FoldersList';
import FolderNode from './folderNode';
import foldersTheme from './foldersTheme.modules.scss';

const SettingsFoldersList = props => {
  const { items, folder, tree, editFolder } = props;
  const current = folder.data || {};

  const selectedMap = {};
  if (current.id && folder.isEdit) selectedMap[current.id] = true;

  const collapseMap = {};
  if (items && items[0]) {
    collapseMap[items[0].id] = false;
  }

  return (
    <Folders
      list={tree}
      selectedMap={selectedMap}
      collapseMap={collapseMap}
      onItemClick={(id, item) => {
        if (!item.code) {
          editFolder(item);
        }
      }}
      componentNode={FolderNode}
      theme={foldersTheme}
      defaultCollapsed={false}
    />
  );
};

SettingsFoldersList.propTypes = {
  items: PropTypes.arrayOf(PropTypes.object),
  folder: PropTypes.instanceOf(Object),
  tree: PropTypes.instanceOf(Object),
  editFolder: PropTypes.func,
};

SettingsFoldersList.defaultProps = {
  items: [],
  folder: {},
  tree: {},
  editFolder: () => {},
};

export default SettingsFoldersList;
