import React from 'react';
import PropTypes from 'prop-types';
import TitleChain from 'modules/heading';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import TagsLayout from '../../containers/TagsLayout';
import css from './styles.modules.scss';

const SettingsTagsLayout = props => {
  if (!props.allData.isLoad) return null;

  const { title, type } = props;
  const { tags } = props.allData;

  return (
    <div className={css.root}>
      <TitleChain>{title}</TitleChain>
      <div className={css.path}>
        {SettingsModule} → {title}
      </div>
      <div className={css.tags}>
        <TagsLayout items={tags} type={type} />
      </div>
    </div>
  );
};

SettingsTagsLayout.propTypes = {
  allData: PropTypes.shape({
    defaultFolderId: PropTypes.number,
    isLoad: PropTypes.bool,
    folders: PropTypes.arrayOf(PropTypes.object),
    tree: PropTypes.instanceOf(Object),
    tags: PropTypes.arrayOf(PropTypes.object),
  }),
  title: PropTypes.string,
  type: PropTypes.string,
};

SettingsTagsLayout.defaultProps = {
  allData: {
    defaultFolderId: undefined,
    isLoad: false,
    folders: [],
    tree: {},
    tags: [],
  },
  title: undefined,
  type: undefined,
};

export default SettingsTagsLayout;
