import React from 'react';
import PropTypes from 'prop-types';
import TitleChain from 'modules/heading';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Layout.i18n';
import FoldersLayout from '../../containers/FoldersLayout';
import TagsLayout from '../../containers/TagsLayout';
import css from './styles.modules.scss';

const i18nTitle = createI18N(keyset)('title');

const SettingsFoldersLayout = props => {
  if (!props.allData.isLoad) return null;

  const { defaultFolderId, folders, tree, tags } = props.allData;

  return (
    <div className={css.root}>
      <TitleChain>{i18nTitle}</TitleChain>
      <div className={css.path}>
        {SettingsModule} → {i18nTitle}
      </div>
      <div className={css.folders}>
        <FoldersLayout items={folders} defaultFolderId={defaultFolderId} tree={tree} />
      </div>
      <div className={css.tags}>
        <TagsLayout items={tags} />
      </div>
    </div>
  );
};

SettingsFoldersLayout.propTypes = {
  allData: PropTypes.shape({
    defaultFolderId: PropTypes.number,
    folders: PropTypes.arrayOf(PropTypes.object),
    tree: PropTypes.instanceOf(Object),
    tags: PropTypes.arrayOf(PropTypes.object),
  }),
};

SettingsFoldersLayout.defaultProps = {
  allData: {
    defaultFolderId: undefined,
    folders: [],
    tree: {},
    tags: [],
  },
};

export default SettingsFoldersLayout;
