import * as React from 'react';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import createI18N from '@yandex-int/i18n';
import * as keyset from './TagsLayout.i18n';
import TagsList from '../TagsList';
import css from './TagsListWithFilter.module.css';

const i18nArchived = createI18N(keyset)('archived');

const { useState } = React;

const TagsListWithFilter = (props) => {
  const [isArchived, setArchived] = useState(false);

  const hanleChange = () => {
    setArchived(!isArchived);
  };

  return (
    <div className={css.b}>
      <div className={css.b__toolbar}>
        <Checkbox onChange={hanleChange} checked={isArchived}>
          {i18nArchived}
        </Checkbox>
      </div>
      <TagsList {...props} isArchived={isArchived} />
    </div>
  );
};

export default TagsListWithFilter;
