import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Tag from 'lego/components/Tag';
import createI18N from '@yandex-int/i18n';
import * as keyset from './TagsList.i18n';
import css from '../TagsLayout/styles.modules.scss';

const i18n = createI18N(keyset);

const SettingsTagsList = (props) => {
  const { items, tag, editTag, isArchived, showLinksCount = true } = props;

  if (!(Array.isArray(items) && items.length)) return null;

  const filteredItems = isArchived ? items : items.filter((item) => !item.isArchived);

  const currentId = tag.data ? tag.data.id : null;
  return (
    <div className={css.list}>
      {filteredItems.map((item) => {
        const currentItemClass = item.id === currentId && !tag.isSave ? css.listItemCurrent : null;
        const isReadOnlyClass = item.isReadOnly ? css.isReadOnly : css.isEditable;

        return (
          <a
            key={item.id}
            className={cx(css.listItem, isReadOnlyClass, currentItemClass, {
              [css.isArchived]: item.isArchived,
            })}
            tabIndex="0"
            onClick={() => {
              if (!item.isReadOnly) editTag(item);
            }}
          >
            <Tag className={css.listItemName} color={item.color} size="xs">
              {item.name}
            </Tag>
            &nbsp;
            {showLinksCount && (
              <span className={css.listItemCount} title={i18n('count', { total: item.mailCount })}>
                {item.mailCount}
              </span>
            )}
          </a>
        );
      })}
    </div>
  );
};

SettingsTagsList.propTypes = {
  items: PropTypes.arrayOf(PropTypes.object),
  tag: PropTypes.instanceOf(Object),
  editTag: PropTypes.func,
};

SettingsTagsList.defaultProps = {
  items: [],
  tag: PropTypes.instanceOf(Object),
  editTag: () => {},
};

export default SettingsTagsList;
