import React from 'react';
import PropTypes from 'prop-types';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from './Tips.i18n';
import css from '../FoldersLayout/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nCreateNew = i18n('createNew');
const i18nAddNew = i18n('addNew');

const SettingsFoldersTip = props => {
  const { folders, folder, addFolder } = props;

  if (!folders.length) {
    const i18nNoFoldersYet = i18nRaw('noFoldersYet', {
      optionalAction: (
        <a tabIndex="0" onClick={addFolder}>
          {i18nCreateNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nNoFoldersYet}</div>;
  }

  if (folder.isSave && !folder.data.id) {
    return <div className={css.tip}>{i18n('folderCreated', { folderName: folder.data.name })}</div>;
  }

  if (folder.isSave) {
    return <div className={css.tip}>{i18n('folderSaved', { folderName: folder.data.name })}</div>;
  }

  if (folder.isDelete) {
    return <div className={css.tip}>{i18n('folderRemoved', { folderName: folder.data.name })}</div>;
  }

  if (!folder.isEdit && !folder.isNew) {
    const i18nChooseFolder = i18nRaw('chooseFolder', {
      optionalAction: (
        <a tabIndex="0" onClick={addFolder}>
          {i18nAddNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nChooseFolder}</div>;
  }

  return null;
};

SettingsFoldersTip.propTypes = {
  folder: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  folders: PropTypes.arrayOf(PropTypes.object),
};

SettingsFoldersTip.defaultProps = {
  folder: {
    data: {},
  },
  folders: [],
};

export default SettingsFoldersTip;
