import React from 'react';
import PropTypes from 'prop-types';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from './Tips.i18n';
import css from '../TagsLayout/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nAddNew = i18n('addNew');
const i18nTagCreated = i18n('tagCreated');

const SettingsTagsTip = (props) => {
  const { items: tags, tag, addTag } = props;

  if (!tag.isNew && !tag.isSave && !tags.length) {
    const i18nNoTagsYet = i18nRaw('noTagsYet', {
      optionalAction: (
        <a tabIndex="0" onClick={addTag}>
          {i18nAddNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nNoTagsYet}</div>;
  }

  if (tag.isSave && !tag.data?.id) {
    return <div className={css.tip}>{i18nTagCreated}</div>;
  }

  if (tag.isSave) {
    let name = '';

    tags.some((item) => {
      if (item.id === tag.data.id) name = item.name;
      return item.id === tag.data.id;
    });

    return <div className={css.tip}>{i18n('tagSaved', { tagName: name })}</div>;
  }

  if (tag.isDelete) {
    return (
      <div className={css.tip}>
        {i18n('tagRemoved', { tagName: tag.responce && tag.responce.name })}
      </div>
    );
  }

  if (!tag.isEdit && !tag.isNew) {
    const i18nChooseTag = i18nRaw('chooseTag', {
      optionalAction: (
        <a tabIndex="0" onClick={addTag}>
          {i18nAddNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nChooseTag}</div>;
  }

  return null;
};

SettingsTagsTip.propTypes = {
  tag: PropTypes.shape({
    data: PropTypes.instanceOf(Object),
  }),
  items: PropTypes.arrayOf(PropTypes.object),
};

SettingsTagsTip.defaultProps = {
  tag: {
    data: {},
  },
  items: [],
};

export default SettingsTagsTip;
