import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from '../foldersAndTags.i18n';
import * as actions from '../actions';
import FolderForm from '../components/FolderForm';

const i18n = createI18N(keyset);
const i18nRequired = createI18N(commonKeyset)('inputRequired');

const validate = values => {
  const errors = {};
  const requiredFields = ['name'];

  requiredFields.forEach(field => {
    if (!values[field] || (values[field].hasOwnProperty('length') && !values[field].length)) {
      errors[field] = i18nRequired;
    }
  });

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const { id, counter, name } = selector(state, 'id', 'counter', 'name');

  return {
    id,
    counter,
    name,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: data => {
    const folder = Object.assign({}, data);

    folder.folderId = folder.id;
    delete folder.id;

    dispatch(actions.saveFolder(folder)).then(responce => {
      if (responce.success === true && typeof props.onSubmitted === 'function') {
        dispatch(actions.loadData());
      }
    });
  },
  onDelete: name => {
    const { id } = props.initialValues;
    const result = confirm(i18n('confirmFolderRemove', { folderName: name }));

    if (!result) return;

    dispatch(actions.deleteFolder(id)).then(responce => {
      if (responce.success === true && typeof props.onDeleted === 'function') {
        dispatch(actions.loadData());
      }
    });
  },
  onReset: () => {
    dispatch(actions.resetFolder());
  },
});

export default connect(mapState, mapDispatch)(reduxForm({ validate })(FolderForm));
