import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import FoldersLayout from '../components/FoldersLayout';

const mapState = state => ({
  folder: get(state, `${NAME}.folder`),
});

const mapDispatch = dispatch => ({
  loadData: () => dispatch(actions.loadData()),
  addFolder: () => dispatch(actions.addFolder()),
  editFolder: data => dispatch(actions.editFolder(data)),
  resetFolder: () => dispatch(actions.resetFolder()),
});

class SettingsFoldersLayout extends Component {
  componentWillUnmount() {
    this.props.resetFolder();
  }

  render() {
    return <FoldersLayout {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(SettingsFoldersLayout);
