import { bindActionCreators } from 'redux';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import { loadByType, resetData } from '../actions';
import reducers from '../reducers';

global.reduxStore.injectReducer(NAME, reducers);

const mapState = state => ({
  allData: get(state, `${NAME}.load`),
});

export default config => WrappedComponent => {
  class SettingsLayout extends Component {
    componentWillMount() {
      this.props.loadData();
    }

    componentWillUnmount() {
      this.props.resetData();
    }

    render() {
      return <WrappedComponent {...this.props} />;
    }
  }

  SettingsLayout.propTypes = {
    loadData: PropTypes.func.isRequired,
    resetData: PropTypes.func.isRequired,
  };

  const ConnectedSettingsLayout = connect(
    mapState,
    (dispatch, props) => ({
      loadData: () => dispatch(loadByType(props.type)),
      resetData: bindActionCreators(resetData, dispatch),
    }),
  )(SettingsLayout);

  ConnectedSettingsLayout.defaultProps = {
    ...config,
  };

  return ConnectedSettingsLayout;
};
