import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../constants';
import * as actions from '../actions';
import TagsLayout from '../components/TagsLayout';

const mapState = state => ({
  tag: get(state, `${NAME}.tag`),
});

const mapDispatch = (dispatch, props) => ({
  loadData: () => dispatch(actions.loadByType(props.type)),
  addTag: () => dispatch(actions.addTag()),
  editTag: data => dispatch(actions.editTag(data)),
  saveTag: data => dispatch(actions.saveTag(data)),
  deleteTag: data => dispatch(actions.deleteTag(data)),
  resetTag: () => dispatch(actions.resetTag()),
});

class SettingsTagsLayout extends Component {
  componentWillUnmount() {
    this.props.resetTag();
  }

  render() {
    return <TagsLayout {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(SettingsTagsLayout);
