import React, { Component } from 'react';
import PropTypes from 'prop-types';
import FoldersPopup from 'modules/settings/components/FoldersPopup';
import FoldersList from 'modules/settings/components/FoldersList';
import cssTree from './styles.modules.scss';
import cx from 'classnames';

export default class Folders extends FoldersPopup {
  renderTree() {
    const { input: { value }, tree } = this.props;

    let selectedMap = {};
    if (value && value !== this.props.id) selectedMap[value] = true;

    let collapseMap = {};
    collapseMap[1] = false;
    const parents = value ? this.getFolderParents(value, tree) : [];
    if (parents.length) {
      parents.forEach((id) => {
        if (id !== value) collapseMap[id] = false;
      });
    }

    return (
      <FoldersList
        list={tree}
        selectedMap={selectedMap}
        collapseMap={collapseMap}
        onItemClick={this.onFolderClick}
        componentNode={this.renderTreeFolder}
        theme={cssTree}
        defaultCollapsed
      />
    );
  }

  renderTreeFolder = (args) => {
    const { id, code, name } = args;
    const { id: currentId, tree } = this.props;
    const isDisabled = this.checkDisabledFolder(id, code, tree, currentId);
    const disabledClassName = isDisabled ? cssTree.disabled : null;

    return (
      <div className={cx(cssTree.node, disabledClassName)}>
        { name }
      </div>
    );
  }

  onFolderClick = (id, item) => {
    const code = item.code;
    const { id: currentId, tree } = this.props;
    const isDisabled = this.checkDisabledFolder(id, code, tree, currentId);

    if (currentId !== id && !isDisabled) {
      this.props.input.onChange(id);
      this.hidePopup();
    }
  }

  checkDisabledFolder = (itemId, itemCode, tree, currentId) => {
    const children = currentId ? this.getFolderChildren(currentId, tree) : [];
    const parents = this.getFolderParents(itemId, tree);

    return itemCode && itemCode !== 'inbox' ||
      children.length && children.indexOf(itemId) > -1 ||
      parents.length >= 4;
  }


  getFolderChildren = (currentId, tree) => {
    if (!currentId || !tree) return false;

    const currentItem = tree[currentId];
    let currentFolderChildren = [];
    currentFolderChildren.push(currentId);

    function fillCurrentFolderChildren(items) {
      items.forEach((i) => {
        currentFolderChildren.push(i);

        const children = tree[i];

        if (children.items && children.items.length) {
          fillCurrentFolderChildren(children.items);
        }
      });
    };

    if (currentItem.items && currentItem.items.length) fillCurrentFolderChildren(currentItem.items);

    return currentFolderChildren;
  }

  getFolderParents = (currentId, tree) => {
    if (!currentId || !tree) return false;

    const currentItem = tree[currentId];
    let currentFolderParents = [];

    function fillCurrentFolderParents(parentId) {
      currentFolderParents.push(parentId);

      const parent = tree[parentId];

      if (parent.parentId) {
        fillCurrentFolderParents(parent.parentId);
      }
    };

    if (currentItem.parentId) fillCurrentFolderParents(currentItem.parentId);

    return currentFolderParents;
  }
}
