import { combineReducers } from 'redux';
import get from 'lodash/get';
import { schema, normalize } from 'normalizr';
import { camelizeKeys } from 'humps';
import * as t from './actionTypes';

const itemSchema = new schema.Entity('items', {}, { idAttribute: entity => entity.id || 'root' });
itemSchema.define({
  items: [itemSchema],
});

const load = (state = {}, action) => {
  switch (action.type) {
    case t.FOLDERS_TAGS_RESET:
      return {};

    case `${t.FOLDERS_TAGS_LOAD}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.FOLDERS_TAGS_LOAD}_RECIEVE`: {
      const { data } = action;
      const tags = data.tags && data.tags.items;
      const folders = data.folders && data.folders.items ?
        { items: data.folders.items } :
        { items: [] };
      const camelizedJson = camelizeKeys(folders);
      const list = Object.assign(
        {},
        normalize(camelizedJson, itemSchema),
      );
      const foldersTree = get(list, 'entities.items');

      return {
        ...state,
        folders: data.folders && data.folders.items,
        tree: foldersTree,
        defaultFolderId: data.folders && data.folders.defaultFolderId,
        tags,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    }
    case `${t.FOLDERS_TAGS_LOAD}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    default:
      return state;
  }
};

const folder = (state = {}, action) => {
  switch (action.type) {
    case t.FOLDER_RESET:
      return {};
    case t.FOLDER_ADD:
      return {
        ...state,
        data: {},
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
    case t.FOLDER_EDIT:
      return {
        ...state,
        data: action.data,
        isNew: false,
        isEdit: true,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
    case `${t.FOLDER_SAVE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.FOLDER_SAVE}_RECIEVE`: {
      // eslint-disable-next-line no-shadow
      const folder = { ...action.args, id: action.args.folderId };
      delete folder.folderId;

      return {
        ...state,
        data: folder,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isReset: false,
        isError: false,
      };
    }
    case `${t.FOLDER_SAVE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };
    case `${t.FOLDER_DELETE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.FOLDER_DELETE}_RECIEVE`:
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isReset: false,
        isError: false,
      };
    case `${t.FOLDER_DELETE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isDelete: false,
        isError: true,
      };
    default:
      return state;
  }
};

const tag = (state = {}, action) => {
  switch (action.type) {
    case t.TAG_RESET:
      return {};
    case t.TAG_ADD:
      return {
        ...state,
        data: {},
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
    case t.TAG_EDIT:
      return {
        ...state,
        data: action.data,
        isNew: false,
        isEdit: true,
        isSave: false,
        isDelete: false,
        isReset: false,
      };
    case t.TAG_SAVE:
      return {
        ...state,
        responce: action.data,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isReset: false,
        isError: false,
      };
    case t.TAG_DELETE:
      return {
        ...state,
        responce: action.data,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isReset: false,
        isError: false,
      };
    default:
      return state;
  }
};

export default combineReducers({ load, folder, tag });
