import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import LayoutFoldersAndTags from './containers/LayoutFoldersAndTags';
import LayoutTags from './containers/LayoutTags';
import LayoutAccountTags from './containers/LayoutAccountTags';
import LayoutEmailTags from './containers/LayoutEmailTags';

export const FoldersRouter = moduleAuthorization('settingsAccess.folders')(LayoutFoldersAndTags);
export const TagsRouter = moduleAuthorization('settingsAccess.tags')(LayoutTags);
export const AccountTagsRouter = moduleAuthorization('settingsAccess.accountTags')(
  LayoutAccountTags,
);
export const EmailTagsRouter = moduleAuthorization('settingsAccess.commMediumTags')(
  LayoutEmailTags,
);
