import { baseCallApi, jsonApiCall } from 'api/common';
import * as t from './actionTypes.js';

const { RULES_RESET } = t;
export const resetData = () => ({
  type: RULES_RESET,
});

const RULES_REQUEST = `${t.RULES_LOAD}_REQUEST`;
const RULES_RECIEVE = `${t.RULES_LOAD}_RECIEVE`;
const RULES_FAIL = `${t.RULES_LOAD}_FAIL`;
export const loadData = () => ({
  type: 'PROMISE',
  actions: [RULES_REQUEST, RULES_RECIEVE, RULES_FAIL],
  promise: baseCallApi({
    url: '/view/usersettings/mailrule/list',
    host: global.CRM_SPACE_API_HOST,
  }),
});

const { RULE_RESET } = t;
export const resetRule = () => ({
  type: RULE_RESET,
});

const { RULE_ADD } = t;
export const addRule = () => ({
  type: RULE_ADD,
});

const { RULE_EDIT } = t;
export const editRule = index => ({
  type: RULE_EDIT,
  index,
});

const { RULE_MOVE } = t;
export const moveRule = rules => ({
  type: RULE_MOVE,
  data: rules,
});

const RULE_POST_REQUEST = `${t.RULE_SAVE}_REQUEST`;
const RULE_POST_RECIEVE = `${t.RULE_SAVE}_RECIEVE`;
const RULE_POST_FAIL = `${t.RULE_SAVE}_FAIL`;
export const saveRule = rules => ({
  type: 'PROMISE',
  actions: [RULE_POST_REQUEST, RULE_POST_RECIEVE, RULE_POST_FAIL],
  promise: jsonApiCall({
    url: '/actions/usersettings/mailrule/save',
    host: global.CRM_SPACE_API_HOST,
    type: 'post',
    data: rules,
  }),
});

const RULE_DELETE_REQUEST = `${t.RULE_DELETE}_REQUEST`;
const RULE_DELETE_RECIEVE = `${t.RULE_DELETE}_RECIEVE`;
const RULE_DELETE_FAIL = `${t.RULE_DELETE}_FAIL`;
export const deleteRule = rules => ({
  type: 'PROMISE',
  actions: [RULE_DELETE_REQUEST, RULE_DELETE_RECIEVE, RULE_DELETE_FAIL],
  promise: jsonApiCall({
    url: '/actions/usersettings/mailrule/save',
    host: global.CRM_SPACE_API_HOST,
    type: 'post',
    data: rules,
  }),
});

const RULE_APPLY_REQUEST = `${t.RULE_APPLY}_REQUEST`;
const RULE_APPLY_RECIEVE = `${t.RULE_APPLY}_RECIEVE`;
const RULE_APPLY_FAIL = `${t.RULE_APPLY}_FAIL`;
export const applyRule = rule => ({
  type: 'PROMISE',
  actions: [RULE_APPLY_REQUEST, RULE_APPLY_RECIEVE, RULE_APPLY_FAIL],
  promise: jsonApiCall({
    url: '/actions/usersettings/mailrule/apply',
    host: global.CRM_SPACE_API_HOST,
    type: 'post',
    data: { rule },
  }),
});
