import React from 'react';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';

const AccountSelect = (props) => {
  const {
    className,
    input: {
      value,
      onChange,
    },
    view: View,
    type,
    disabled,
    viewProps,
    onCancel,
    defaultValue = {},
    ...rest
  } = props;

  return (
    <ClientFind
      className={className}
      name={`MAIL_RULES_SEARCH_CLIENT_${type}`}
      onSubmit={({ id, login, name }) => {
        onChange({ accountId: id, login, name });
      }}
      onCancel={() => {
        if (typeof onCancel === 'function') {
          onCancel();
        }
      }}
    >
      {(modal, open) => (
        <View
          modal={modal}
          open={open}
          value={value || defaultValue}
          disabled={disabled}
          {...viewProps}
          {...rest}
        />
      )}
    </ClientFind>
  );
};

export default AccountSelect;
