import React from 'react';
import ModalField from 'uiLib/ModalField/index';
import createI18N from '@yandex-int/i18n';
import getAccountVal from '../../../utils/getAccountVal';
import * as keyset from '../FormFields.i18n';

const i18nChoose = createI18N(keyset)('choose');

const AccountView = props => {
  const { className, value = {}, open, modal, disabled } = props;
  const val = getAccountVal(value, i18nChoose);

  return (
    <ModalField className={className} onClick={open} disabled={disabled}>
      {val}
      {modal}
    </ModalField>
  );
};

export default AccountView;
