import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../FormFields.i18n';
import getAccountVal from '../../../utils/getAccountVal';

const i18n = createI18N(keyset);
const i18nChooseAccount = i18n('chooseAccount');
const i18nNoAccount = i18n('noAccount');

const AccountView = (props) => {
  const {
    className,
    classNameButton,
    classNameInput,
    size = 'm',
    value = {},
    open,
    modal,
    disabled,
    ...rest
  } = props;
  const val = getAccountVal(value);

  return (
    <div className={className} onClick={open}>
      <Button view="pseudo" size={size} disabled={disabled} pin="round-brick">
        {i18nChooseAccount}
      </Button>
      <Textinput
        size={size}
        placeholder={i18nNoAccount}
        pin="clear-round"
        {...rest}
        value={val}
        disabled
      />
      {modal}
    </div>
  );
};

export default AccountView;
