import React, { Component } from 'react';
import withError from 'requestForms/components/withError';
import InlineView from './InlineView';
import InputView from './InputView';
import Field from './Field';

class AccountSelectInlineView extends Component {
  render() {
    return (
      <Field
        {...this.props}
        type="INLINE"
        view={InlineView}
      />
    );
  }
}

class AccountSelectInputView extends Component {
  render() {
    return (
      <Field
        {...this.props}
        type="INPUT"
        view={InputView}
      />
    );
  }
}

const AccountSelectInline = withError(AccountSelectInlineView);
const AccountSelectInput = withError(AccountSelectInputView);

export {
  AccountSelectInline,
  AccountSelectInput,
};
