import React from 'react';
import FoldersPopup from 'modules/settings/components/FoldersPopup';
import FoldersList from 'modules/settings/components/FoldersList';
import cssTree from './styles.modules.scss';

const renderRulesFoldersTreeItem = (props = {}) => {
  return (
    <div className={cssTree.node}>
      {props.name}
    </div>
  );
};

export default class SettingsRulesMoveToFolder extends FoldersPopup {
  renderTree() {
    const { input: { value }, tree } = this.props;

    let selectedMap = {};
    if (value) selectedMap[value] = true;

    let collapseMap = {};

    return (
      <FoldersList
        list={tree}
        selectedMap={selectedMap}
        collapseMap={collapseMap}
        onItemClick={(id) => {
          this.props.input.onChange(id);
          this.hidePopup();
        }}
        componentNode={renderRulesFoldersTreeItem}
        theme={cssTree}
        defaultCollapsed
      />
    );
  }
}
