import React from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import isUndefined from 'lodash/isUndefined';
import RuleForm from '../../containers/RuleForm';
import meta from '../RuleForm/meta';

const SettingsRule = props => {
  const { rulesData, foldersData } = props;
  const rules = get(rulesData, 'data.rules', []);
  const rule = get(rulesData, 'data.rule', {});
  const folders = get(foldersData, 'tree', {});
  const tags = get(foldersData, 'tags', []);
  const index = get(rulesData, 'data.index');

  if (!rulesData.isLoad || (!rulesData.isNew && !rulesData.isEdit)) return null;

  const formName = `SettingsRule${rulesData.isEdit ? index : 'isNew'}`;
  const initialValues = rulesData.isEdit ? { ...rule } : meta.initialValues;

  if (initialValues.actions && !initialValues.actions.isRemove) {
    initialValues.actionsIsFolder = !isUndefined(get(initialValues, 'actions.moveToFolderId'));
    initialValues.actionsIsTag = !isUndefined(get(initialValues, 'actions.markTagId'));
    initialValues.actionsIsAccount = !isUndefined(get(initialValues, 'actions.setAccount'));
  }

  return (
    <RuleForm
      key={formName}
      form={formName}
      initialValues={initialValues}
      data={{
        index,
        rules,
        folders,
        tags,
        rule,
      }}
    />
  );
};

SettingsRule.propTypes = {
  rulesData: PropTypes.shape({
    data: PropTypes.shape({
      rules: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
  foldersData: PropTypes.instanceOf(Object),
};

SettingsRule.defaultProps = {
  rulesData: {
    data: {
      rules: [],
    },
  },
  foldersData: {},
};

export default SettingsRule;
