import React from 'react';
import { Field } from 'redux-form';
import Select from 'lego/redux-form/Select';
import CheckBox from 'lego/redux-form/CheckBox';
import Tooltip from '@crm/components/dist/lego2/Tooltip';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import * as keyset from './RuleForm.i18n';
import FolderSelect from '../FormFields/FolderSelect';
import { AccountSelectInline as AccountSelect } from '../FormFields/AccountSelect';
import css from './styles.modules.scss';
import meta from './meta';

const i18n = createI18N(keyset);
const i18nExecuteAction = i18n('executeAction');
const i18nFoldersAreUnavailable = i18n('foldersAreUnavailable');
const i18nNoTags = i18n('noTags');

const RenderActions = (props) => {
  const {
    change,
    data: { folders, tags },
    actionsIsRemove,
    actionsIsFolder,
    actionsIsTag,
    actionsIsAccount,
    error,
  } = props;

  const containerRef = React.useRef(null);

  return (
    <div ref={containerRef} className={css.actionsBlock}>
      <div className={css.field}>
        <div className={cx(css.block, css.actionsGroup)}>
          <div className={cx(css.label, css.requiredStar)}>{i18nExecuteAction}</div>
          <div>
            <div className={cx(css.row, css.actionSelect)}>
              <Field
                name="actionsIsFolder"
                id="actionsIsFolder"
                component={CheckBox}
                disabled={actionsIsRemove}
              >
                {meta.fields.actionsIsFolder.caption}
              </Field>

              {folders && Object.keys(folders).length > 1 ? (
                <Field
                  className={css.setFolder}
                  name="actions.moveToFolderId"
                  id="actions.moveToFolderId"
                  component={FolderSelect}
                  props={{
                    tree: folders,
                  }}
                  disabled={actionsIsRemove || !actionsIsFolder}
                />
              ) : (
                <span className={css.emptyTip}>{i18nFoldersAreUnavailable}</span>
              )}
            </div>

            <div className={cx(css.row, css.actionSelect)}>
              <Field
                name="actionsIsTag"
                id="actionsIsTag"
                component={CheckBox}
                disabled={actionsIsRemove}
              >
                {meta.fields.actionsIsTag.caption}
              </Field>

              {!tags || (tags && !tags.length) ? (
                <span className={css.emptyTip}>{i18nNoTags}</span>
              ) : (
                <Field
                  className={css.setTag}
                  name="actions.markTagId"
                  id="actions.markTagId"
                  component={Select}
                  size="s"
                  disabled={actionsIsRemove || !actionsIsTag}
                  options={tags.map((item) => ({
                    value: String(item.id),
                    content: item.name,
                  }))}
                />
              )}
            </div>

            <div className={cx(css.row, css.actionSelect)}>
              <Field
                name="actionsIsAccount"
                id="actionsIsAccount"
                component={CheckBox}
                disabled={actionsIsRemove}
              >
                {meta.fields.actionsIsAccount.caption}
              </Field>

              <Field
                className={css.setAccount}
                name="actions.setAccount"
                id="actions.setAccount"
                component={AccountSelect}
                disabled={!actionsIsAccount}
              />
            </div>

            <div className={css.row}>
              <Field name="actions.markAsRead" id="actions.markAsRead" component={CheckBox}>
                {meta.fields.markAsRead.caption}
              </Field>
            </div>

            <div className={css.row}>
              <Field
                name="actions.markAsImportant"
                id="actions.markAsImportant"
                component={CheckBox}
              >
                {meta.fields.markAsImportant.caption}
              </Field>
            </div>

            <div className={css.row}>
              <Field
                name="actions.isRemove"
                id="actions.isRemove"
                component={CheckBox}
                onChange={(e, value) => {
                  if (value) {
                    change('actionsIsFolder', false);
                    change('actionsIsTag', false);
                    change('actionsIsAccount', false);
                  }
                }}
              >
                {meta.fields.action_delete.caption}
              </Field>
            </div>
          </div>
        </div>
      </div>
      <Tooltip
        view="default"
        state="alert"
        padding="xs"
        hasTail
        scope={containerRef}
        anchor={containerRef}
        visible={!!error}
        direction="right-center"
        zIndex={1000}
      >
        {error}
      </Tooltip>
    </div>
  );
};

export default RenderActions;
