import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './RuleForm.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);

export default {
  fields: {
    operator: {
      type: 'enum',
      fType: 'select',
      map: {
        or: i18n('operatorOr'),
        and: i18n('operatorAnd'),
      },
      list: ['or', 'and'],
    },
    letters: {
      type: 'enum',
      fType: 'select',
      map: {
        1: i18n('allExcludeSpam'),
        2: i18n('allIncludeSpam'),
        3: i18n('onlySpam'),
      },
      list: [1, 2, 3],
    },
    attachments: {
      type: 'enum',
      fType: 'select',
      map: {
        1: i18n('canBeWithAttachments'),
        2: i18n('onlyWithAttachments'),
        3: i18n('onlyWithoutAttachments'),
      },
      list: [1, 2, 3],
    },
    conditions: {
      caption: i18n('conditions'),
      type: 'array',
    },
    condition: {
      caption: i18n('condition'),
      type: 'array',
    },
    conditionType: {
      type: 'enum',
      fType: 'select',
      map: {
        from: commonI18n('fromWhom'),
        to: commonI18n('toWhom'),
        cc: commonI18n('aCopy'),
        tocc: i18n('toWhomOrCopy'),
        subject: commonI18n('subject'),
        body: commonI18n('body'),
        header: commonI18n('header'),
        account: commonI18n('account'),
      },
      list: ['from', 'to', 'cc', 'tocc', 'subject', 'body', 'header', 'account'],
    },
    conditionOperator: {
      type: 'enum',
      fType: 'select',
      map: {
        equal: i18n('equal'),
        notEqual: i18n('notEqual'),
        contains: i18n('contains'),
        notContains: i18n('notContains'),
      },
      list: ['equal', 'notEqual', 'contains', 'notContains'],
    },
    value: {
      caption: i18n('text'),
      type: 'string',
    },
    action: {
      type: 'enum',
      fType: 'select',
      map: {
        1: commonI18n('remove'),
        2: i18n('markAsRead'),
        3: i18n('moveToFolder'),
        4: i18n('setTag'),
      },
      list: [1, 2, 3, 4],
    },
    action_delete: {
      caption: commonI18n('remove'),
      type: 'bool',
    },
    markAsRead: {
      caption: i18n('markAsRead'),
      type: 'bool',
    },
    markAsImportant: {
      caption: i18n('markAsImportant'),
      type: 'bool',
    },
    actionsIsFolder: {
      caption: i18n('moveToFolder'),
      type: 'bool',
    },
    actionsIsTag: {
      caption: i18n('setTag'),
      type: 'bool',
    },
    actionsIsAccount: {
      caption: i18n('setAccount'),
      type: 'bool',
    },
    folderId: {
      caption: i18n('folder'),
      type: 'string',
    },
    tagId: {
      caption: i18n('tag'),
      type: 'string',
    },
    skipOther: {
      caption: i18n('skipOtherRules'),
      type: 'bool',
    },
  },
  initialValues: {
    operator: 'or',
    conditions: [
      {
        conditionType: 'from',
        operator: 'equal',
        name: 'sender',
      },
    ],
    actions: {},
  },
};
