import React from 'react';
import PropTypes from 'prop-types';
import { SortableContainer, SortableElement } from 'react-sortable-hoc';
import Empty from 'components/Empty';
import createI18N from '@yandex-int/i18n';
import * as keyset from './RulesList.i18n';
import RenderItem from '../RulesListItem';
import css from './styles.modules.scss';

const i18nNoRules = createI18N(keyset)('noRules');

const RenderSortableList = ({ items, passThroughProps }) => {
  const SortableItem = SortableElement(RenderItem);

  return (
    <div className={css.list}>
      {items.map((value, index) => (
        <SortableItem
          key={index}
          index={index}
          itemIndex={index}
          item={value}
          {...passThroughProps}
        />
      ))}
    </div>
  );
};

const SettingsRulesList = props => {
  const { rules } = props;

  if (!rules || !rules.length) {
    return <Empty text={i18nNoRules} icon={null} />;
  }

  const { folders, tags, isEdit, onEdit, onDelete, onSortEnd } = props;
  const SortableList = SortableContainer(RenderSortableList);

  return (
    <SortableList
      items={rules}
      useDragHandle
      helperClass="isDragged"
      onSortEnd={onSortEnd}
      passThroughProps={{
        rules,
        folders,
        tags,
        isEdit,
        onEdit,
        onDelete,
      }}
    />
  );
};

SettingsRulesList.propTypes = {
  rules: PropTypes.arrayOf(PropTypes.object),
  folders: PropTypes.instanceOf(Object),
  tags: PropTypes.arrayOf(PropTypes.object),
  isEdit: PropTypes.bool,
  onEdit: PropTypes.func,
  onDelete: PropTypes.func,
  onSortEnd: PropTypes.func,
};

SettingsRulesList.defaultProps = {
  rules: [],
  folders: {},
  tags: [],
  isEdit: false,
  onEdit: () => {},
  onDelete: () => {},
  onSortEnd: () => {},
};

export default SettingsRulesList;
