import React from 'react';
import PropTypes from 'prop-types';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from './Tip.i18n';
import css from '../Layout/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);
const i18nAddNew = i18n('addNew');
const i18nSaved = i18n('saved');
const i18nRemoved = i18n('removed');

const SettingsRulesTip = props => {
  const { rulesData, addRule } = props;
  const rulesDataRules = rulesData.data && rulesData.data.rules;

  if (!rulesData.isLoad) return null;
  if (!rulesDataRules.length && !rulesData.isEdit && !rulesData.isNew) {
    const i18nNoRuleYet = i18nRaw('noRuleYet', {
      optionalAction: (
        <a onClick={addRule} tabIndex="0">
          {i18nAddNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nNoRuleYet}</div>;
  }
  if (rulesData.isSave) {
    return <div className={css.tip}>{i18nSaved}</div>;
  }
  if (rulesData.isDelete) {
    return <div className={css.tip}>{i18nRemoved}</div>;
  }
  if (!rulesData.isEdit && !rulesData.isNew) {
    const i18nChooseFromList = i18nRaw('chooseFromList', {
      optionalAction: (
        <a onClick={addRule} tabIndex="0">
          {i18nAddNew}
        </a>
      ),
    });

    return <div className={css.tip}>{i18nChooseFromList}</div>;
  }
  return null;
};

SettingsRulesTip.propTypes = {
  rulesData: PropTypes.shape({
    data: PropTypes.shape({
      rules: PropTypes.arrayOf(PropTypes.object),
    }),
  }),
  addRule: PropTypes.func,
};

SettingsRulesTip.defaultProps = {
  rulesData: {
    data: {
      rules: [],
    },
  },
  addRule: () => {},
};

export default SettingsRulesTip;
