import React, { Component } from 'react';
import { connect } from 'react-redux';
import get from 'lodash/get';
import * as rulesConstants from '../constants';
import * as rulesActions from '../actions';
import reducers from '../reducers';
import * as foldersConstants from '../../foldersAndTags/constants';
import * as foldersActions from '../../foldersAndTags/actions';
import Layout from '../components/Layout';

global.reduxStore.injectReducer(rulesConstants.NAME, reducers);

const mapState = state => ({
  rulesData: get(state, `${rulesConstants.NAME}.rules`),
  foldersData: get(state, `${foldersConstants.NAME}.load`),
});

const mapDispatch = dispatch => ({
  loadRules: () => dispatch(rulesActions.loadData()),
  resetRules: () => dispatch(rulesActions.resetData()),
  addRule: () => dispatch(rulesActions.addRule()),
  resetRule: () => dispatch(rulesActions.resetRule()),
  loadFolders: () => dispatch(foldersActions.loadData()),
  resetFolders: () => dispatch(foldersActions.resetData()),
});

class SettingsRulesLayout extends Component {
  componentWillMount() {
    this.props.loadRules().then(() => {
      this.props.loadFolders();
    });
  }

  componentWillUnmount() {
    this.props.resetRule();
    this.props.resetRules();
    this.props.resetFolders();
  }

  render() {
    return <Layout {...this.props} />;
  }
}

export default connect(mapState, mapDispatch)(SettingsRulesLayout);
