import { connect } from 'react-redux';
import { arrayMove } from 'react-sortable-hoc';
import createI18N from '@yandex-int/i18n';
import * as actions from '../actions';
import RulesList from '../components/RulesList';
import * as keyset from '../mailRules.i18n';

const i18nRemoveConfirm = createI18N(keyset)('removeConfirm');

const mapDispatch = (dispatch, props) => {
  const moveRule = data => dispatch(actions.moveRule(data));
  const saveRule = data =>
    dispatch(actions.saveRule(data)).then(response => {
      if (response.success === true) {
        return dispatch(actions.loadData());
      }

      return response;
    });

  return {
    onEdit: data => dispatch(actions.editRule(data)),
    onDelete: index => {
      const { rules } = props;
      const result = confirm(i18nRemoveConfirm);

      if (index === undefined || !result) return;

      rules.splice(index, 1);

      dispatch(actions.deleteRule({ rules })).then(response => {
        if (response.success === true) {
          dispatch(actions.loadData());
        }
      });
    },
    onSortEnd: ({ oldIndex, newIndex }) => {
      if (oldIndex === newIndex) return;

      const { rules } = props;
      const newRules = arrayMove(rules, oldIndex, newIndex);

      moveRule({ rules: newRules });

      saveRule({ rules: newRules }).catch(() => {
        moveRule({ rules: arrayMove(newRules, newIndex, oldIndex) });
      });
    },
  };
};

export default connect(null, mapDispatch)(RulesList);
