import { combineReducers } from 'redux';
import * as t from './actionTypes';

const rules = (state = {}, action) => {
  switch (action.type) {
    case t.RULES_RESET:
      return {};

    case `${t.RULES_LOAD}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.RULES_LOAD}_RECIEVE`:
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    case `${t.RULES_LOAD}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };

    case t.RULE_RESET:
      const rulesReset = state.data && state.data.rules ? state.data.rules.slice() : [];

      rulesReset.length &&
        rulesReset.some((item, index, arr) => {
          if (item.isEdit) {
            arr[index].isEdit = undefined;
          }

          return item.isEdit;
        });

      return {
        ...state,
        data: { rules: rulesReset },
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isError: false,
      };

    case t.RULE_ADD:
      const rulesAdd = state.data && state.data.rules ? state.data.rules.slice() : [];

      rulesAdd.some((item, index, arr) => {
        if (item.isEdit) {
          arr[index].isEdit = undefined;
        }
        return item.isEdit;
      });

      return {
        ...state,
        data: { rules: rulesAdd },
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
      };

    case t.RULE_MOVE:
      return {
        ...state,
        data: action.data,
      };

    case t.RULE_EDIT:
      const rulesEdit = state.data && state.data.rules ? state.data.rules.slice() : [];
      const index = action.index;
      const rule = rulesEdit[index];

      if (rule) {
        rulesEdit.some((item, index, arr) => {
          if (item.isEdit) {
            arr[index].isEdit = undefined;
          }
          return item.isEdit;
        });

        rule.isEdit = true;
      }

      return {
        ...state,
        data: { rules: rulesEdit, index, rule },
        isNew: false,
        isEdit: true,
        isSave: false,
        isDelete: false,
      };

    case `${t.RULE_SAVE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.RULE_SAVE}_RECIEVE`:
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isError: false,
      };
    case `${t.RULE_SAVE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };

    case `${t.RULE_DELETE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.RULE_DELETE}_RECIEVE`:
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isError: false,
      };
    case `${t.RULE_DELETE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isDelete: false,
        isError: true,
      };
    case `${t.RULE_APPLY}_REQUEST`:
      return {
        ...state,
        data: {
          ...state.data,
          rule: { ...state.data.rule, canImmediately: false },
        },
      };
    default:
      return state;
  }
};

export default combineReducers({ rules });
