import { baseCallApi } from 'api/common';
import { push } from 'modules/notificationsUI/actions';
import createI18N from '@yandex-int/i18n';
import * as keyset from './mailing.i18n';

const i18n = createI18N(keyset);

export const uploadMailing = data => dispatch => {
  return baseCallApi({
    url: '/actions/triggermailing/save',
    data,
    type: 'POST',
    processData: false,
    contentType: false,
  }).then(id => {
    dispatch(
      push({
        theme: 'success',
        text: i18n('createSuccess', {
          mailingId: id,
        }),
      }),
    );
  });
};
