import React from 'react';
import TitleChain from 'modules/heading';
import createI18N from '@yandex-int/i18n';
import { MODULE_NAME as SettingsModule } from 'modules/settings/constants';
import SettingsForm from '../SettingsForm';
import { NAME } from '../../constants';
import css from './styles.modules.scss';

import * as keyset from '../../mailing.i18n';

const i18n = createI18N(keyset);
const i18nMailing = i18n('mailing');
const i18nCommon = i18n('common');

const Layout = props => (
  <div className={css.wrap}>
    <TitleChain>{i18nMailing}</TitleChain>
    <div className={css.path}>
      {SettingsModule} → {i18nCommon} → {i18nMailing}
    </div>
    <div className={css.addresses}>
      <SettingsForm form={NAME} onSubmit={props.uploadMailing} enableReinitialize />
    </div>
  </div>
);

export default Layout;
