import React from 'react';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Button from '@crm/components/dist/lego2/Button/Button';
import css from './style.modules.scss';

import * as keyset from '../mailing.i18n';

const i18n = createI18N(keyset);
const i18nSave = createI18N(commonKeyset)('save');
const i18nTemplateId = i18n('templateId');
const i18nCsvFile = i18n('csvFile');

const SettingsForm = (props) => {
  const { onSubmit } = props;
  return (
    <form
      action=""
      onSubmit={(e) => {
        e.preventDefault();

        const formObj = e.target;
        const formData = new FormData(formObj);
        onSubmit(formData).then(() => {
          if (formObj) {
            formObj.reset();
          }
        });
      }}
    >
      <div className={css.body}>
        <div className={css.rowsBlock}>
          <div className={css.valueGroup}>
            <span className={css.label}>{i18nTemplateId}</span>
            <input className={css.field} name="ExternalTemplateId" type="text" />
          </div>

          <div className={css.valueGroup}>
            <span className={css.label}>{i18nCsvFile}</span>
          </div>

          <div className={css.valueGroup}>
            <input type="file" name="file" />
          </div>
        </div>
      </div>

      <div className={css.actions}>
        <Button type="submit" view="action">
          {i18nSave}
        </Button>
      </div>
    </form>
  );
};

export default SettingsForm;
