import React from 'react';
import { Form as RFF, Field } from 'react-final-form';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { FormikTableControl } from '../TableControl';
import css from './Form.scss';

const i18nSave = createI18N(commonKeyset)('save');

const Form = (props) => {
  const { initialValues, onSubmit, className, scheme } = props;

  return (
    <RFF
      onSubmit={onSubmit}
      initialValues={initialValues}
      render={(formProps) => (
        <form onSubmit={formProps.handleSubmit} className={className}>
          <Field name="notifications" component={FormikTableControl} scheme={scheme} />
          <div className={css.b__footer}>
            <Button type="submit" view="action" disabled={formProps.submitting}>
              {i18nSave}
            </Button>
          </div>
        </form>
      )}
    />
  );
};

export default Form;
