import React from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import get from 'lodash/get';
import createI18N from '@yandex-int/i18n';
import { push } from 'modules/notificationsUI/actions';
import * as keyset from './Form.i18n';
import redux from '../../redux';
import Form from './Form';

const i18nSettingsSaved = createI18N(keyset)('settingsSaved');

class FormContainer extends React.Component {
  componentDidMount() {
    this.promise = this.props.get(this.props.code);
  }

  componentWillUnmount() {
    this.promise.cancel();
    this.props.destroy();
  }

  handleSubmit = (values = {}) => {
    return this.props.post(this.props.code, values.notifications);
  };

  render() {
    const { formState, get: listGet, ...props } = this.props;

    const data = get(formState, 'data');

    if (data) {
      const initialValues = data.value ? { notifications: data.value } : undefined;

      return (
        <Form
          {...props}
          onSubmit={this.handleSubmit}
          initialValues={initialValues}
          scheme={data.schema}
        />
      );
    }

    return null;
  }
}

export default connect(
  (state) => ({
    formState: redux.selectors.form(state) || {},
  }),
  (dispatch) => {
    return {
      post: (...args) => {
        return dispatch(redux.actions.form.post(...args)).then((data) => {
          dispatch(push({ theme: 'success', text: i18nSettingsSaved }));
          return data;
        });
      },
      ...bindActionCreators(
        {
          get: redux.actions.form.get,
          destroy: redux.actions.form.destroy,
        },
        dispatch,
      ),
    };
  },
)(FormContainer);
