import React from 'react';
import { Route } from 'react-router-dom';
import Form from '../Form';
import List from '../List';
import css from './Layout.scss';

const Layout = ({ match }) => (
  <div className={css.b}>
    <List className={css.b__list} match={match} />
    <Route
      path={`${match.url}/:code`}
      component={({ match }) => <Form className={css.b__form} code={match.params.code} />}
    />
  </div>
);

export default Layout;
