import React from 'react';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import VerticalNavigationMenu from 'components/VerticalNavigationMenu';
import Title from 'modules/settings/components/Title';
import * as keyset from './List.i18n';
import css from './List.scss';

const i18nTitle = createI18N(keyset)('title');

const List = (props) => {
  const { className, match, items } = props;

  return (
    <VerticalNavigationMenu
      className={cx(className, css.b)}
      match={match}
      items={items}
      beforeComponent={<Title title={i18nTitle} />}
    />
  );
};

List.defaultProps = {
  items: [],
};

export default List;
